function [rx_packages_to_demod] = averaging_channel_estimate(rx_packages_OFDM_demod,rx_training_symbols,N, BlockLength)

length_training = length(rx_training_symbols);
number_of_blocks = length_training/BlockLength;
length_rx_packages = length(rx_packages_OFDM_demod);

training_matrix = reshape(rx_training_symbols,[BlockLength,number_of_blocks]);
rx_matrix = reshape(rx_packages_OFDM_demod(1:length_training),[BlockLength,number_of_blocks]);

temp_rx_packages =zeros(1,BlockLength)';
temp_training_symbols =zeros(1,BlockLength)';
rx_packages_to_demod = [];

factors = [];

for k=1:number_of_blocks
    l=rx_matrix(:,k)./training_matrix(:,k);
    factors = [factors, rx_matrix(:,k)./training_matrix(:,k)];

end

channel_estimate = sum(factors,2)/number_of_blocks;
    

for ii = 1:BlockLength:length_rx_packages-BlockLength+1
      
    rx_packages_to_demod = [rx_packages_to_demod, rx_packages_OFDM_demod(ii:ii+BlockLength-1)./channel_estimate.'];
    
end

% figure()
% 
% stem(real(rx_packages_to_demod(1:length_training)));hold on;stem(real(rx_training_symbols))

end




